/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.swing.filechooser.FileSystemView;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public final class AcsLaunchLocator {
    private static AcsLaunchLocator m_locator = null;
    private LocationType m_locationType = null;
    private final URL m_url;

    public static synchronized AcsLaunchLocator getLocator() throws NullPointerException, SecurityException {
        return null == m_locator ? (m_locator = new AcsLaunchLocator()) : m_locator;
    }

    private AcsLaunchLocator() throws NullPointerException, SecurityException {
        ProtectionDomain protectionDomain = AcsLaunchPad.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL uRL = codeSource.getLocation();
        this.m_url = AcsLaunchLocator.fixSpecialPaths(uRL);
    }

    private static URL fixSpecialPaths(URL uRL) {
        try {
            String string = uRL.toString();
            String string2 = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase(Locale.US);
            AcsStartupUtil.addDelayedLog("Checking if we need to adjust URL for UNC path names: " + string);
            if (string.matches("^file://[^/]+.*") && string2.contains("windows") && !AcsLaunchLocator.canConstructFileFromURL(uRL)) {
                URL uRL2 = new URL(string.replaceFirst("^file://", Matcher.quoteReplacement("file:////")));
                AcsStartupUtil.addDelayedLog("Adjusted URL for UNC path names. Was '" + uRL + "', now '" + uRL2 + "'");
                return uRL2;
            }
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        return uRL;
    }

    private static boolean canConstructFileFromURL(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        return null != file;
    }

    public synchronized LocationType getLocationType() {
        if (null != this.m_locationType) {
            return this.m_locationType;
        }
        if (null == this.m_url) {
            this.m_locationType = LocationType.OTHER;
            return this.m_locationType;
        }
        String string = this.m_url.toString().toLowerCase(Locale.US);
        boolean bl = string.startsWith("http:");
        bl = bl || string.startsWith("https:");
        bl = bl || string.startsWith("ftp:");
        boolean bl2 = bl = bl || null != System.getProperty("javawebstart.version");
        if (bl) {
            this.m_locationType = LocationType.WEBSTART;
            return this.m_locationType;
        }
        if (string.startsWith("smb:")) {
            this.m_locationType = LocationType.FILE_PROBABLY_REMOTE;
            return this.m_locationType;
        }
        if (!string.startsWith("file:")) {
            this.m_locationType = LocationType.OTHER;
            return this.m_locationType;
        }
        try {
            File file = new File(this.m_url.toURI());
            String string2 = file.getCanonicalPath();
            AcsStartupUtil.addDelayedLog("launch file path is " + string2);
            if (string2.startsWith("\\\\") || string2.startsWith("//")) {
                this.m_locationType = LocationType.FILE_PROBABLY_REMOTE;
                return this.m_locationType;
            }
            if (string2.toUpperCase(Locale.US).startsWith("C:")) {
                this.m_locationType = LocationType.FILE_PROBABLY_LOCAL;
                return this.m_locationType;
            }
            if (string2.toLowerCase(Locale.US).startsWith("/tmp/")) {
                this.m_locationType = LocationType.FILE_PROBABLY_LOCAL;
                return this.m_locationType;
            }
            if (string2.toLowerCase(Locale.US).startsWith("/home/")) {
                this.m_locationType = LocationType.FILE_PROBABLY_LOCAL;
                return this.m_locationType;
            }
            if (string2.toLowerCase(Locale.US).startsWith("/mnt/")) {
                this.m_locationType = LocationType.FILE_PROBABLY_REMOTE;
                return this.m_locationType;
            }
            if (string2.matches("^[a-zA-Z]:.*")) {
                this.m_locationType = AcsLaunchLocator.isDefinitelyWindowsNetworkShareDriveLetterPath(string2) ? LocationType.FILE_PROBABLY_REMOTE : LocationType.FILE_UNKNOWN;
                return this.m_locationType;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_locationType = LocationType.FILE_UNKNOWN;
        return this.m_locationType;
    }

    private static boolean isDefinitelyWindowsNetworkShareDriveLetterPath(String string) {
        if (!System.getProperty("os.name", "").toLowerCase(Locale.US).contains("windows")) {
            return false;
        }
        if (!string.matches("^[a-zA-Z]:.*")) {
            return false;
        }
        AcsStartupUtil.addDelayedLog("Checking to see if file path is network share: " + string);
        String string2 = string.replaceAll(":.*", Matcher.quoteReplacement(":\\"));
        File file = new File(string2);
        AcsStartupUtil.addDelayedLog("Drive seems to be: " + file);
        String string3 = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
        AcsStartupUtil.addDelayedLog("Drive type seems to be: " + string3);
        if (string3 == null) {
            return false;
        }
        return string3.toLowerCase(Locale.US).startsWith("network");
    }

    public URL getUrl() {
        return this.m_url;
    }

    public boolean isInsideJarOrZip() {
        String string = this.m_url.toString().toLowerCase(Locale.US);
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            return true;
        }
        try {
            File file = new File(this.m_url.toURI()).getCanonicalFile();
            if (file.isFile()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static enum LocationType {
        FILE_PROBABLY_LOCAL,
        FILE_PROBABLY_REMOTE,
        FILE_UNKNOWN,
        OTHER,
        WEBSTART;


        public boolean isFile() {
            switch (this) {
                case FILE_PROBABLY_LOCAL: 
                case FILE_PROBABLY_REMOTE: 
                case FILE_UNKNOWN: {
                    return true;
                }
            }
            return false;
        }

        public boolean isWebStart() {
            return this == WEBSTART;
        }
    }
}

